function [ exdeltap,M,np,errp ] = prdspl_aux( orig_delta,r,d1,d2 )
%Output M(i,j,:) which expresses Nid1*Njd2 product on basis of S^r_(d1+d2)
%   By computing these quantities once, we won't have to compute it
%   everytime we want to multiply arbitrary splines over the same
%   partition.

%Build the extended knot sequences.
[exdelta1,n1] = extpar(orig_delta,r,d1);
[exdelta2,n2] = extpar(orig_delta,r,d2);
[exdeltap,np] = extpar(orig_delta,r,d1+d2); %Knot sequence belonging to product

%Take basis-many evenly spaced sample points spanning [a,b]
t = orig_delta(1,1):(orig_delta(1,size(orig_delta,2))-orig_delta(1,1))/np:orig_delta(1,size(orig_delta,2));
t=t';

%Compute M 
M = zeros(n1,n2,np);
Merrp = zeros(n1,n2);
Id1 = eye(n1); %For writing coeffs on std basis S^r,d1
Id2 = eye(n2); %For writing coeffs on std basis S^r,d2
for i=1:n1
    for j=1:n2
        %Evaluate Nid1*Njd2 at the evenly spaced points
        val1 = sval2(d1,exdelta1,n1,Id1(i,:),t);
        val2 = sval2(d2,exdelta2,n2,Id2(j,:),t);

        valp = val1.*val2; %Compute the product
        %Find coeffs of product spline and error of fit
        [M(i,j,:),Merrp(i,j)] = lsqspl(d1+d2,np,exdeltap,t,valp);
    end
end

errp = max(max(Merrp));

end

